// (C)1997 Christian Janoff
// D64.CC

#include <iostream.h>
#include "c1541.h"
#include "file.h"
#include "pkstring.h"

void c1541disk::d64(char* filename, int mode)
{
 int trk, sec, bytes;
 pkstring fname,
          base=filename,
          path=filename;

 base.conv2basename();
 path.conv2pathname();

 if (mode==READ && path.string()) fname=path+"/";
 fname=fname+base;

 if (mode==WRITE)  // has_prefix should support wildcards in the future...
	{
	  if (fname.has_prefix("1!")) fname.remove_prefix("1!");
	  if (fname.has_prefix("2!")) fname.remove_prefix("2!");
	  if (fname.has_prefix("3!")) fname.remove_prefix("3!");
	  if (fname.has_prefix("4!")) fname.remove_prefix("4!");
	}

 if (!fname.has_suffix(".d64"))
   fname=fname+".d64";

 iofile_open(fname.string(),mode);

 for(trk=1;trk<nbtracks+1;trk++)
   for(sec=0;sec<nbsectors_of_track(trk);sec++)
     for(bytes=0;bytes<256;bytes++)
       if (mode==READ)
	 put_byte(trk, sec, bytes, iofile_get_byte());
       else
	 iofile_put_byte(get_byte(trk,sec,bytes));

 iofile_close();

 if (mode==READ && option_verbose)
   cout << "Successfully read disk image." << endl;
}

